/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.input;

import de.willuhn.jameica.gui.input.TextInput;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class DecimalInput
extends TextInput {
    private DecimalFormat format = (DecimalFormat)DecimalFormat.getInstance(Application.getConfig().getLocale());
    private Number value = null;
    private Control control = null;

    public DecimalInput(DecimalFormat format) {
        this((Number)null, format);
    }

    public DecimalInput(double d, DecimalFormat format) {
        this(Double.isNaN(d) ? null : Double.valueOf(d), format);
    }

    public DecimalInput(Number n, DecimalFormat format) {
        super(null);
        this.value = n;
        if (format != null) {
            this.format = format;
            if (n != null && n instanceof BigDecimal) {
                this.format.setParseBigDecimal(true);
            }
        }
        this.addListener(new Listener(){

            public void handleEvent(Event event) {
                if (event.type == 15) {
                    DecimalInput.this.text.selectAll();
                } else if (event.type == 16) {
                    DecimalInput.this.setValue(DecimalInput.this.getValue());
                }
            }
        });
    }

    @Override
    public Control getControl() {
        if (this.control != null) {
            return this.control;
        }
        this.control = super.getControl();
        try {
            this.text.setText(this.value == null ? "" : this.format.format(this.value));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.text.addListener(25, new Listener(){

            public void handleEvent(Event e) {
                char komma = DecimalInput.this.format.getDecimalFormatSymbols().getDecimalSeparator();
                char group = DecimalInput.this.format.getDecimalFormatSymbols().getGroupingSeparator();
                boolean groupingUsed = DecimalInput.this.format.isGroupingUsed();
                char[] chars = e.text.toCharArray();
                for (int i = 0; i < chars.length; ++i) {
                    if (Character.isWhitespace(chars[i])) continue;
                    if ((chars[i] < '0' || chars[i] > '9') && chars[i] != '-' && chars[i] != komma && chars[i] != group) {
                        e.doit = false;
                        return;
                    }
                    if (chars[i] == komma && DecimalInput.this.text.getText().indexOf(komma) != -1 && e.text.indexOf(komma) != -1) {
                        e.doit = false;
                        return;
                    }
                    if (groupingUsed || chars[i] != group) continue;
                    e.doit = false;
                    return;
                }
            }
        });
        return this.control;
    }

    @Override
    public Object getValue() {
        Number n = this.getNumber();
        return n == null ? null : Double.valueOf(n.doubleValue());
    }

    public Number getNumber() {
        if (this.text == null || this.text.isDisposed()) {
            return this.value;
        }
        Object s = this.text.getText();
        if (s == null || ((String)s).length() == 0) {
            return null;
        }
        s = StringUtils.deleteWhitespace((String)s);
        try {
            if (this.format.isGroupingUsed()) {
                DecimalFormatSymbols symbols = this.format.getDecimalFormatSymbols();
                char komma = symbols.getDecimalSeparator();
                char group = symbols.getGroupingSeparator();
                if (((String)s).indexOf(komma) != -1 && ((String)s).indexOf(group) != -1) {
                    s = ((String)s).replace("" + group, "");
                }
                int lastDot = ((String)s).lastIndexOf(group);
                if (((String)s).indexOf(komma) == -1 && lastDot != -1 && ((String)s).length() - 3 == lastDot) {
                    s = ((String)s).substring(0, lastDot) + komma + ((String)s).substring(lastDot + 1);
                }
            }
            return this.format.parse((String)s);
        }
        catch (Exception e) {
            Logger.error((String)("unable to parse text as decimal number: " + (String)s), (Throwable)e);
            return null;
        }
    }

    @Override
    public void setValue(Object value) {
        if (value instanceof Number) {
            this.value = (Number)value;
        } else if (value instanceof String) {
            try {
                this.value = this.format.parse(StringUtils.deleteWhitespace((String)((String)value)));
            }
            catch (Exception e) {
                Logger.error((String)("unable to parse " + value));
            }
        } else {
            this.value = null;
        }
        this.format();
    }

    private void format() {
        if (this.text == null || this.text.isDisposed()) {
            return;
        }
        this.text.setText("");
        if (this.value != null) {
            this.text.setText(this.format.format(this.value));
        }
        this.text.redraw();
    }
}

